/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.tables.client.inventory.module.GenericScreen;

public class DynamicContainerScreen
extends ModuleScreen {
    protected static final ScalableElementScreen slot = GenericScreen.slot;
    private static final ScalableElementScreen slotEmpty = GenericScreen.slotEmpty;
    protected static final ElementScreen sliderNormal = GenericScreen.sliderNormal;
    protected static final ElementScreen sliderLow = GenericScreen.sliderLow;
    protected static final ElementScreen sliderHigh = GenericScreen.sliderHigh;
    protected static final ElementScreen sliderTop = GenericScreen.sliderTop;
    protected static final ElementScreen sliderBottom = GenericScreen.sliderBottom;
    protected static final ScalableElementScreen sliderBackground = GenericScreen.sliderBackground;
    protected SliderWidget slider = new SliderWidget(sliderNormal, sliderHigh, sliderLow, sliderTop, sliderBottom, sliderBackground);
    protected int columns;
    protected int rows;
    protected int slotCount;
    protected boolean sliderActive;
    protected int firstSlotId;
    protected int lastSlotId;
    protected final class_1703 container;

    public DynamicContainerScreen(MultiModuleScreen<?> parent, class_1703 container, class_1661 playerInventory, class_2561 title) {
        super(parent, container, playerInventory, title, false, false);
        this.container = container;
        this.xOffset = 7;
        this.yOffset = 17;
        this.field_2792 = 162;
        this.field_2779 = 54;
        this.slotCount = container.field_7761.size();
        this.firstSlotId = 0;
        this.lastSlotId = this.slotCount;
    }

    @Override
    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.field_2776 = parentX + this.xOffset;
        this.field_2800 = parentY + this.yOffset;
        this.columns = this.field_2792 / DynamicContainerScreen.slot.w;
        this.rows = this.field_2779 / DynamicContainerScreen.slot.h;
        this.sliderActive = this.slotCount > this.columns * this.rows;
        this.updateSlider();
        if (this.sliderActive) {
            this.columns = (this.field_2792 - this.slider.width) / DynamicContainerScreen.slot.w;
            this.updateSlider();
        }
        this.updateSlots();
    }

    protected void updateSlider() {
        int max = 0;
        if (this.sliderActive) {
            this.slider.show();
            max = (this.slotCount - 1) / this.columns - this.rows + 1;
        } else {
            this.slider.hide();
        }
        this.slider.setPosition(this.field_2776 + this.field_2792 - this.slider.width, this.field_2800);
        this.slider.setSize(this.field_2779);
        this.slider.setSliderParameters(0, max, 1);
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.sliderActive) {
            return false;
        }
        if (mouseButton == 0 && mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height)) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (!this.sliderActive) {
            return false;
        }
        this.slider.handleMouseReleased();
        return mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height);
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.sliderActive) {
            return false;
        }
        return this.slider.mouseScrolled(scrollData, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule((int)mouseX, (int)mouseY));
    }

    public void update(int mouseX, int mouseY) {
        if (!this.sliderActive) {
            return;
        }
        this.slider.update(mouseX, mouseY);
        this.updateSlots();
    }

    @Override
    public boolean shouldDrawSlot(class_1735 slot) {
        if (!this.slider.isEnabled()) {
            return true;
        }
        int index = slot.getSlotIndex();
        return this.firstSlotId <= index && this.lastSlotId > index;
    }

    public void updateSlots() {
        int oldFirstSlot = this.firstSlotId;
        int oldLastSlot = this.lastSlotId;
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.rows * this.columns);
        if (oldFirstSlot != this.firstSlotId || oldLastSlot != this.lastSlotId) {
            for (class_1735 slot : this.container.field_7761) {
                if (this.shouldDrawSlot(slot)) {
                    int offset = slot.getSlotIndex() - this.firstSlotId;
                    int x = offset % this.columns * DynamicContainerScreen.slot.w;
                    int y = offset / this.columns * DynamicContainerScreen.slot.h;
                    slot.field_7873 = this.xOffset + x + 1;
                    slot.field_7872 = this.yOffset + y + 1;
                    continue;
                }
                slot.field_7873 = 0;
                slot.field_7872 = 0;
            }
        }
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int y;
        RenderUtils.setup(GenericScreen.LOCATION);
        if (!this.slider.isHidden()) {
            this.slider.draw(graphics, GenericScreen.LOCATION);
            this.updateSlots();
        }
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        int w = this.columns * DynamicContainerScreen.slot.w;
        for (y = 0; y < fullRows * DynamicContainerScreen.slot.h && y < this.field_2779; y += DynamicContainerScreen.slot.h) {
            slot.drawScaledX(graphics, GenericScreen.LOCATION, this.field_2776, this.field_2800 + y, w);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            slot.drawScaledX(graphics, GenericScreen.LOCATION, this.field_2776, this.field_2800 + y, slotsLeft * DynamicContainerScreen.slot.w);
            slotEmpty.drawScaledX(graphics, GenericScreen.LOCATION, this.field_2776 + slotsLeft * DynamicContainerScreen.slot.w, this.field_2800 + y, w - slotsLeft * DynamicContainerScreen.slot.w);
        }
    }
}

